﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Notatnik.NET
{
    public partial class Form1 : Form
    {
        string ścieżkaPliku = "";
        bool tekstZmieniony = false;
        Stack<string> cofnijLista = new Stack<string>(); // lista pamięci stanu cofania.
        Stack<string> ponowLista = new Stack<string>(); // lista pamięci stanu ponów.
        string confijStanPoczatkowy;

        public Form1()
        {
            InitializeComponent();
            confijStanPoczatkowy = textBox1.Text;
        }

        #region Metody pomocnicze
        private void ustalTytułOkna()
        {
            this.Text =
                Path.GetFileName(ścieżkaPliku) +
                (tekstZmieniony ? "*" : "") +
                " - Notatnik.NET";
        }

        private bool zapiszDoPlikuJako()
        {
            //if (!string.IsNullOrWhiteSpace(ścieżkaPliku))
            if (File.Exists(ścieżkaPliku))
            {
                saveFileDialog1.InitialDirectory = Path.GetDirectoryName(ścieżkaPliku);
                saveFileDialog1.FileName = Path.GetFileName(ścieżkaPliku);
            }
            else
            {
                saveFileDialog1.FileName = "";
            }
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.ReadOnly = false;
                File.WriteAllLines(saveFileDialog1.FileName, textBox1.Lines);
                ścieżkaPliku = saveFileDialog1.FileName;
                tekstZmieniony = false;
                ustalTytułOkna();
                return true;
            }
            else return false;
        }

        private bool zapiszDoPliku()
        {
            try
            {
                if (!File.Exists(ścieżkaPliku)) return zapiszDoPlikuJako();
                else
                {
                    File.WriteAllLines(ścieżkaPliku, textBox1.Lines);
                    tekstZmieniony = false;
                    ustalTytułOkna();
                    return true;
                }
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd podczas zapisywania: " + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                return false;
            }
        }

        private bool spytajCzyZapisać()
        {
            DialogResult dr = MessageBox.Show(
                "Czy chcesz zapisać zmiany w pliku " + ścieżkaPliku + "?",
                this.Text,
                MessageBoxButtons.YesNoCancel,
                MessageBoxIcon.Question);
            switch (dr)
            {
                case DialogResult.Yes:
                    return zapiszDoPliku();
                case DialogResult.No:
                    return true;
                case DialogResult.Cancel:
                    return false;
                default:
                    throw new Exception("Nieprzewidziana wartość zmiennej 'dr'");
            }
        }

        private void wyczyśćNotatnik()
        {
            textBox1.Text = "";
            ścieżkaPliku = "";
            tekstZmieniony = false;
            ustalTytułOkna();
            wyczyscBuforZmian();
        }
        #endregion

        #region Metody zdarzeniowe
        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                openFileDialog1.FileName = ścieżkaPliku;
                if (openFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    wyczyscBuforZmian();
                    textBox1.Lines = File.ReadAllLines(openFileDialog1.FileName);
                    textBox1.ReadOnly = openFileDialog1.ReadOnlyChecked;
                    ścieżkaPliku = openFileDialog1.FileName;                    
                    tekstZmieniony = false;
                    ustalTytułOkna();
                    confijStanPoczatkowy = textBox1.Text;
                }
            }
            catch(Exception exc)
            {
                MessageBox.Show(
                    "Błąd odczytu pliku: " + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
            }
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //zawartość przeniesiona do osobnej metody
            zapiszDoPlikuJako();
        }

        private void zmieńKolorTła(object sender, EventArgs e)
        {
            colorDialog1.Color = textBox1.BackColor;
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.BackColor = colorDialog1.Color;
            }
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = textBox1.Font;
            fontDialog1.Color = textBox1.ForeColor;
            if(fontDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.Font = fontDialog1.Font;
                textBox1.ForeColor = fontDialog1.Color;
            }
        }

        private void zawijanieWierszyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //zawijanieWierszyToolStripMenuItem.Checked = !zawijanieWierszyToolStripMenuItem.Checked;
            textBox1.WordWrap = zawijanieWierszyToolStripMenuItem.Checked;
        }

        private void zapiszToolStripMenuItem_Click(object sender, EventArgs e)
        {
            zapiszDoPliku();
        }

        private void nowyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!tekstZmieniony) wyczyśćNotatnik();
            else if (spytajCzyZapisać()) wyczyśćNotatnik();
            confijStanPoczatkowy = textBox1.Text;
        }

        DateTime czasPoprzedniegoPomiaru = DateTime.MaxValue;        

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            tekstZmieniony = true;
            ustalTytułOkna();

            DateTime czasPomiaru = DateTime.Now;
            double prędkość = 1 / (czasPomiaru - czasPoprzedniegoPomiaru).TotalSeconds;
            czasPoprzedniegoPomiaru = czasPomiaru;

            toolStripStatusLabel1.Text = "Liczba znaków: " + textBox1.Text.Length;
            toolStripStatusLabel1.Text += ", prędkość: " + prędkość.ToString("N2");

        }

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!tekstZmieniony) Close();
            else if (spytajCzyZapisać()) Close();
        }
        #endregion

        private void cofnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if(textBox1.Text != confijStanPoczatkowy)
                ponowLista.Push(textBox1.Text); // dodaję do listy ponów aktualny stan textboxu

            if (cofnijLista.Count() > 0)
            {
                textBox1.Text = cofnijLista.Pop(); // z listy cofnij usuwam ostatni rekord i wczytuję stan poprzedniego do textboxu.
            }   
            else
                textBox1.Text = confijStanPoczatkowy; // jezeli ilość listy cofania jest pusta czyszcze textbox.

            textBox1.Select();
            textBox1.Select(textBox1.Text.Length, 0); // ustawiam kursor na końcu tekstu.
        }

        private void ponowStripMenuItem6_Click(object sender, EventArgs e)
        {
            if (ponowLista.Count() > 0) // jeżeli lista ponow nie jest pusta to dodaję do listy cofania aktualny stan textboxu  
            {
                cofnijLista.Push(textBox1.Text);
                textBox1.Text = ponowLista.Pop(); // ...a do textboxu wstawiam poprzedni stan listy ponow...
            }               

            textBox1.Select();
            textBox1.Select(textBox1.Text.Length, 0);

        }

        private void wytnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Cut();
        }

        private void kopiujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //Clipboard.SetText(textBox1.SelectedText);
            textBox1.Copy();            
        }

        private void wklejToolStripMenuItem_Click(object sender, EventArgs e)
        {            
            textBox1.Paste();
        }

        private void usuńToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = "";
        }

        private void zaznaczWszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectAll();
        }

        private void godzinaDataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DateTime dt = DateTime.Now;
            //string gd = dt.ToString(System.Globalization.CultureInfo.InvariantCulture);
            //string gd = dt.ToString(System.Globalization.CultureInfo.CreateSpecificCulture("pl-PL"));
            string gd = dt.ToString();
            textBox1.SelectedText = gd;
        }

        // w tej metodzie sprawdzam czy naduszono enter lub spacja. Tylko w tedy dodaję stan textboxa do listy cofania.
        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)13 || e.KeyChar == (char)32)
            {
                if(ponowLista.Count > 0) // sprawdzam, czy lista ponow jest już wypełniona. Jeżeli tak to przy ponownym wpisywaniu czyszcze ją do zera aby mieć listę ponowienia ze stanem zerowym.
                    ponowLista.Clear();

                cofnijLista.Push(textBox1.Text); // dodaję aktalny stan do listy cofania.
            }

        }

        private void wyczyscBuforZmian()
        {
            ponowLista.Clear();
            cofnijLista.Clear();
        }

    }
}
